/*
  <behavior jsname="behavior_Boat" description="Move like a boat">
        <property name="MinForwardSpeed" type="float" default="0.1" />
        <property name="MaxForwardSpeed" type="float" default="0.2" />
        <property name="ReverseSpeed" type="float" default="0.1" />
        <property name="ActionOnMinForward" type="action" default="" />
        <property name="ActionOnMaxForward" type="action" default="" />
        <property name="ActionOnReverse" type="action" default="" />
        <property name="ActionOnStop" type="action" default="" />
  </behavior>
*/

behavior_Boat = function () {
    this.mode = null;
    this.keyA = false;
    this.keyB = false;
    this.lastTime = Date.now();
};

behavior_Boat.prototype.onAnimate = function (node) {
    var now = Date.now();
    var delta = now - this.lastTime;
    var pos = ccbGetSceneNodeProperty(node, "Position");
    
    switch (this.mode) {
        case 1:
            pos.x += this.MinForwardSpeed * delta;
            ccbSetSceneNodeProperty(node, "Position", pos);
            ccbInvokeAction(this.ActionOnMinForward);
            break;
        case 2:
            pos.x += this.MaxForwardSpeed * delta;
            ccbSetSceneNodeProperty(node, "Position", pos);
            ccbInvokeAction(this.ActionOnMaxForward); 
            break;
        case -1:
            pos.x -= this.ReverseSpeed * delta;
            ccbSetSceneNodeProperty(node, "Position", pos);
            ccbInvokeAction(this.ActionOnReverse); 
            break;
        case -2:
            ccbInvokeAction(this.ActionOnStop);
            break;
        default:
            // Do nothing 
            break;
    }
    this.lastTime = now;
}

behavior_Boat.prototype.onKeyEvent = function (key, pressed) {

    if (key == 87 && pressed) {
        if (!this.keyA) {
            this.mode = 1;
        }
        if (this.keyA) {
            this.mode = 2;
        }
    }
    if (key == 83 && pressed) {
        if (!this.keyB) {
            this.mode = -1;
        }
        if (this.keyB) {
            this.mode = -2;
        }
    }

    if (key == 87 && !pressed) {
        this.keyA = true;
        this.keyB = false;
    }
    if (key == 83 && !pressed) {
        this.keyB = true;
        this.keyA = false;
    }
}